qui {
noi {
	/*************************************************/
	/************* Step 3.2. Univariate analysis *****/
	/*************************************************/
}
		
	* Plot univariate conditional correlations
	
		* Load data
		cd ..
		cd "./4. Master data"
		use master_data_secondstep, clear
		cd ..

		* Keep relevant years & variables
		keep if independence_years >= 0
		keep cntrycode cntry region year independence_years PTDIDD transition pvalue region baseline_lgdpcap market_potential referendum_dummy open dem bdeaths crisis popshare rmspe violent_secession landlocked initial_gdpcap

		* Standardize all covariates
		ds cntrycode year region cntry independence_years transition pvalue landlocked violent_secession referendum_dummy crisis, not
		foreach covariate in `r(varlist)' {
			egen `covariate'_std = std(`covariate')
			replace `covariate' = `covariate'_std
			drop `covariate'_std
			}
			
		* Scatter plots

			* Population
			twoway 	(scatter PTDIDD popshare if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD popshare if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD popshare if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD popshare if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD popshare, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD popshare if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					if popshare < 2, xlab(-.5(.5)1.5) xtitle("Standardized population share", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_1.pdf, replace
			cd ..
			
			* Trade openness
			twoway 	(scatter PTDIDD open if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD open if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD open if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD open if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD open, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD open if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					if open < 3, xlab(-2(1)3) xtitle("Standardized trade openness", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_2.pdf, replace
			cd ..
			
			* Market potential
			twoway 	(scatter PTDIDD market_potential if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD market_potential if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD market_potential if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD market_potential if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD market_potential, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD market_potential if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					if market_potential < 5, xlab(-2(1)5) xtitle("Standardized market potential", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_3.pdf, replace
			cd ..

			* Landlocked	
			twoway 	(scatter PTDIDD landlocked if pvalue > .1, msym(Oh) mcolor(gs14) msize(large) jitter(20))	///
					(scatter PTDIDD landlocked if pvalue > .05 & pvalue <= .1, mcolor(gs12) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD landlocked if pvalue > .01 & pvalue <= .05, mcolor(gs8) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD landlocked if pvalue <= .01, mcolor(gs0) msym(Oh) msize(large) jitter(20)) ///
					(lfit PTDIDD landlocked, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD landlocked if pvalue <= .1, lcolor(gs0) lw(thick)) ///
			, xlab(0 "No" 1 "Yes") xscale(range(-.5 1.5)) xtitle("Landlocked", size(large)) ytitle("Standardized independence dividend", size(medlarge)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small))
			cd ".\5. TeX results"
			graph export figure13_4.pdf, replace
			cd ..
			
			* Democracy
			twoway 	(scatter PTDIDD dem if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD dem if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD dem if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD dem if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD dem, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD dem if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					, xlab(-2(1)2) xtitle("Standardized democracy", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_5.pdf, replace
			cd ..
			
			* Violent secession
			twoway 	(scatter PTDIDD violent_secession if pvalue > .1, msym(Oh) mcolor(gs14) msize(large) jitter(20))	///
					(scatter PTDIDD violent_secession if pvalue > .05 & pvalue <= .1, mcolor(gs12) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD violent_secession if pvalue > .01 & pvalue <= .05, mcolor(gs8) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD violent_secession if pvalue <= .01, mcolor(gs0) msym(Oh) msize(large) jitter(20)) ///
					(lfit PTDIDD violent_secession, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD violent_secession if pvalue <= .1, lcolor(gs0) lw(thick)) ///
			, xlab(0 "No" 1 "Yes") xscale(range(-.5 1.5)) xtitle("Violent secession", size(large)) ytitle("Standardized independence dividend", size(medlarge)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small))
			cd ".\5. TeX results"
			graph export figure13_6a.pdf, replace
			cd ..
			
			* War-related deaths
			twoway 	(scatter PTDIDD bdeaths if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD bdeaths if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD bdeaths if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD bdeaths if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD bdeaths, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD bdeaths if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					if bdeaths < 3, xlab(-.5(.5)3) xtitle("Standardized battle deaths", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_6b.pdf, replace
			cd ..
			
			* Financial crises
			twoway 	(scatter PTDIDD crisis if pvalue > .1, msym(Oh) mcolor(gs14) msize(large) jitter(20))	///
					(scatter PTDIDD crisis if pvalue > .05 & pvalue <= .1, mcolor(gs12) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD crisis if pvalue > .01 & pvalue <= .05, mcolor(gs8) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD crisis if pvalue <= .01, mcolor(gs0) msym(Oh) msize(large) jitter(20)) ///
					(lfit PTDIDD crisis, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD crisis if pvalue <= .1, lcolor(gs0) lw(thick)) ///
			, xlab(0 "No" 1 "Yes") xscale(range(-.5 1.5)) xtitle("Financial crisis", size(large)) ytitle("Standardized independence dividend", size(medlarge)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small))
			cd ".\5. TeX results"
			graph export figure13_7.pdf, replace
			cd ..
			
			* Transition country
			twoway 	(scatter PTDIDD transition if pvalue > .1, msym(Oh) mcolor(gs14) msize(large) jitter(20))	///
					(scatter PTDIDD transition if pvalue > .05 & pvalue <= .1, mcolor(gs12) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD transition if pvalue > .01 & pvalue <= .05, mcolor(gs8) msym(Oh) msize(large) jitter(20)) ///
					(scatter PTDIDD transition if pvalue <= .01, mcolor(gs0) msym(Oh) msize(large) jitter(20)) ///
					(lfit PTDIDD transition, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD transition if pvalue <= .1, lcolor(gs0) lw(thick)) ///
			, xlab(0 "No" 1 "Yes") xscale(range(-.5 1.5)) xtitle("Transition country", size(large)) ytitle("Standardized independence dividend", size(medlarge)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small))
			cd ".\5. TeX results"
			graph export figure13_8.pdf, replace
			cd ..

			
			* Initial per capita GDP
			twoway 	(scatter PTDIDD initial_gdpcap if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD initial_gdpcap if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD initial_gdpcap if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD initial_gdpcap if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD initial_gdpcap, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD initial_gdpcap if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					if initial_gdpcap < 2.5, xlab(-.5(.5)1.5) xtitle("Standardized initial per capita GDP", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_9.pdf, replace
			cd ..
			
			* Year
			twoway 	(scatter PTDIDD year if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD year if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD year if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD year if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD year, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD year if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					, xtitle("Year", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_10.pdf, replace
			cd ..
			
			* Years-of-independence
			twoway 	(scatter PTDIDD independence_years if pvalue > .1, mcolor(gs14) msize(small)) ///
					(scatter PTDIDD independence_years if pvalue > .05 & pvalue <= .1, mcolor(gs12) msize(small)) ///
					(scatter PTDIDD independence_years if pvalue > .01 & pvalue <= .05, mcolor(gs8) msize(small)) ///
					(scatter PTDIDD independence_years if pvalue <= .01, mcolor(gs0) msize(small)) ///
					(lfit PTDIDD independence_years, lcolor(gs8) lpattern(dash) lw(thick)) ///
					(lfit PTDIDD independence_years if pvalue <= .1, lcolor(gs0) lw(thick)) ///
					, xtitle("Years of independence", size(large)) ytitle("Standardized independence dividend", size(medlarge)) xline(0, lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white) legend(order(4 "p<.01" 3 "p<.05" 2 "p<.1" 1 "p>.1") rows(1) size(medium) symxsize(small)) 
			cd ".\5. TeX results"
			graph export figure13_11.pdf, replace
			cd ..
				
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
